/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.webbeans.DuplicateBindingTypeException;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacadeImpl<T> {
    protected final Set<? extends Annotation> bindingTypes;
    protected final Manager manager;
    protected final Class<T> type;

    protected FacadeImpl(Class<T> type, Manager manager, Annotation ... bindingTypes) {
        this.manager = manager;
        this.type = type;
        this.bindingTypes = this.mergeBindingTypes(new HashSet(), bindingTypes);
    }

    protected Set<Annotation> mergeBindingTypes(Set<? extends Annotation> currentBindings, Annotation ... newBindings) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        result.addAll(currentBindings);
        for (Annotation newAnnotation : newBindings) {
            if (!Reflections.isBindingType(newAnnotation)) {
                throw new IllegalArgumentException(newAnnotation + " is not a binding type for " + this);
            }
            if (result.contains(newAnnotation)) {
                throw new DuplicateBindingTypeException(newAnnotation + " is already present in the bindings list for " + this);
            }
            if (this.getFilteredAnnotations().contains(newAnnotation.annotationType())) continue;
            result.add(newAnnotation);
        }
        return result;
    }

    protected abstract Set<Class<? extends Annotation>> getFilteredAnnotations();

    protected Annotation[] mergeBindings(Annotation ... newBindingTypes) {
        return this.mergeBindingTypes(this.bindingTypes, newBindingTypes).toArray(new Annotation[0]);
    }

    public String toString() {
        return "Abstract facade implmentation";
    }
}

