/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.webbeans.AmbiguousDependencyException;
import javax.webbeans.BindingType;
import javax.webbeans.ContextNotActiveException;
import javax.webbeans.DeploymentException;
import javax.webbeans.DuplicateBindingTypeException;
import javax.webbeans.Observer;
import javax.webbeans.Production;
import javax.webbeans.Standard;
import javax.webbeans.TypeLiteral;
import javax.webbeans.UnsatisfiedDependencyException;
import javax.webbeans.manager.Bean;
import javax.webbeans.manager.Context;
import javax.webbeans.manager.Decorator;
import javax.webbeans.manager.InterceptionType;
import javax.webbeans.manager.Interceptor;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.MetaDataCache;
import org.jboss.webbeans.Resolver;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.proxy.ProxyPool;
import org.jboss.webbeans.contexts.ContextMap;
import org.jboss.webbeans.event.EventManager;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.jlr.AnnotatedClassImpl;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Standard
public class ManagerImpl
implements Manager {
    public static final String JNDI_KEY = "java:comp/Manager";
    private List<Class<? extends Annotation>> enabledDeploymentTypes;
    private EventManager eventManager;
    private Resolver resolver;
    private ContextMap contextMap;
    private ProxyPool proxyPool;
    private List<Bean<?>> beans = new CopyOnWriteArrayList();
    private Set<Decorator> decorators;
    private Set<Interceptor> interceptors;

    public ManagerImpl() {
        this.resolver = new Resolver(this);
        this.proxyPool = new ProxyPool();
        this.decorators = new HashSet<Decorator>();
        this.interceptors = new HashSet<Interceptor>();
        this.contextMap = new ContextMap();
        this.eventManager = new EventManager(this);
        ArrayList<Class<? extends Annotation>> defaultEnabledDeploymentTypes = new ArrayList<Class<? extends Annotation>>();
        defaultEnabledDeploymentTypes.add(0, Standard.class);
        defaultEnabledDeploymentTypes.add(1, Production.class);
        this.setEnabledDeploymentTypes(defaultEnabledDeploymentTypes);
    }

    protected void checkEnabledDeploymentTypes() {
        if (!this.enabledDeploymentTypes.get(0).equals(Standard.class)) {
            throw new DeploymentException("@Standard must be the lowest precedence deployment type");
        }
    }

    public Manager addBean(Bean<?> bean) {
        if (this.beans.contains(bean)) {
            return this;
        }
        this.resolver.clear();
        this.beans.add(bean);
        return this;
    }

    public <T> Set<AnnotatedMethod<Object>> resolveDisposalMethods(Class<T> apiType, Annotation ... bindings) {
        return new HashSet<AnnotatedMethod<Object>>();
    }

    public <T> Set<Observer<T>> resolveObservers(T event, Annotation ... bindings) {
        return this.eventManager.getObservers(event, bindings);
    }

    public List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        return Collections.unmodifiableList(this.enabledDeploymentTypes);
    }

    public void setEnabledDeploymentTypes(List<Class<? extends Annotation>> enabledDeploymentTypes) {
        this.enabledDeploymentTypes = enabledDeploymentTypes;
        this.checkEnabledDeploymentTypes();
    }

    public <T> Set<Bean<T>> resolveByType(Class<T> type, Annotation ... bindings) {
        return this.resolveByType(new AnnotatedClassImpl<T>(type, type, bindings), bindings);
    }

    public <T> Set<Bean<T>> resolveByType(TypeLiteral<T> type, Annotation ... bindings) {
        return this.resolveByType(new AnnotatedClassImpl(type.getRawType(), type.getType(), bindings), bindings);
    }

    public <T> Set<Bean<T>> resolveByType(AnnotatedItem<T, ?> element, Annotation ... bindings) {
        for (Annotation annotation : element.getAnnotations()) {
            if (MetaDataCache.instance().getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        for (Type type : element.getActualTypeArguments()) {
            if (type instanceof WildcardType) {
                throw new IllegalArgumentException("Cannot resolve a type parameterized with a wildcard " + element);
            }
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException("Cannot resolve a type parameterized with a type parameter " + element);
        }
        if (bindings.length > element.getMetaAnnotations(BindingType.class).size()) {
            throw new DuplicateBindingTypeException(element.toString());
        }
        return this.resolver.get(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeans(Set<AbstractBean<?, ?>> beans) {
        Set<AbstractBean<?, ?>> set = beans;
        synchronized (set) {
            this.beans = new CopyOnWriteArrayList(beans);
            this.resolver.clear();
        }
    }

    public List<Bean<?>> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    public Manager addContext(Context context) {
        this.contextMap.add(context);
        return this;
    }

    public Manager addDecorator(Decorator decorator) {
        this.decorators.add(decorator);
        return this;
    }

    public Manager addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public <T> Manager addObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        this.eventManager.addObserver(observer, eventType, bindings);
        return this;
    }

    public <T> Manager addObserver(Observer<T> observer, TypeLiteral<T> eventType, Annotation ... bindings) {
        this.eventManager.addObserver(observer, (Class)eventType.getType(), bindings);
        return this;
    }

    public void fireEvent(Object event, Annotation ... bindings) {
        if (Reflections.isParameterizedType(event.getClass())) {
            throw new IllegalArgumentException("Event type " + event.getClass().getName() + " is not allowed because it is a generic");
        }
        for (Annotation binding : bindings) {
            if (Reflections.isBindingType(binding)) continue;
            throw new IllegalArgumentException("Event type " + event.getClass().getName() + " cannot be fired with non-binding type " + binding.getClass().getName() + " specified");
        }
        Set observers = this.resolveObservers(event, bindings);
        this.eventManager.notifyObservers(observers, event);
    }

    public Context getContext(Class<? extends Annotation> scopeType) {
        ArrayList<Context> activeContexts = new ArrayList<Context>();
        for (Context context : this.contextMap.getContext(scopeType)) {
            if (!context.isActive()) continue;
            activeContexts.add(context);
        }
        if (activeContexts.isEmpty()) {
            throw new ContextNotActiveException("No active contexts for scope type " + scopeType.getName());
        }
        if (activeContexts.size() > 1) {
            throw new IllegalArgumentException("More than one context active for scope type " + scopeType.getName());
        }
        return (Context)activeContexts.iterator().next();
    }

    public Context getBuiltInContext(Class<? extends Annotation> scopeType) {
        return this.contextMap.getBuiltInContext(scopeType);
    }

    public <T> T getInstance(Bean<T> bean) {
        if (MetaDataCache.instance().getScopeModel(bean.getScopeType()).isNormal()) {
            return this.proxyPool.getClientProxy(bean);
        }
        return (T)this.getContext(bean.getScopeType()).get(bean, true);
    }

    public Object getInstanceByName(String name) {
        Set<Bean<?>> beans = this.resolveByName(name);
        if (beans.size() == 0) {
            return null;
        }
        if (beans.size() > 1) {
            throw new AmbiguousDependencyException("Resolved multiple Web Beans with " + name);
        }
        return this.getInstance(beans.iterator().next());
    }

    public <T> T getInstanceByType(Class<T> type, Annotation ... bindings) {
        return this.getInstanceByType(new AnnotatedClassImpl<T>(type, type, bindings), bindings);
    }

    public <T> T getMostSpecializedInstance(Bean<T> bean, boolean create) {
        return this.getInstance(bean);
    }

    public <T> T getInstanceByType(TypeLiteral<T> type, Annotation ... bindings) {
        return this.getInstanceByType(new AnnotatedClassImpl(type.getRawType(), type.getType(), bindings), bindings);
    }

    public <T> T getInstanceByType(AnnotatedItem<T, ?> element, Annotation ... bindings) {
        Set<Bean<T>> beans = this.resolveByType(element, bindings);
        if (beans.size() == 0) {
            throw new UnsatisfiedDependencyException(element + "Unable to resolve any Web Beans");
        }
        if (beans.size() > 1) {
            throw new AmbiguousDependencyException(element + "Resolved multiple Web Beans");
        }
        return this.getInstance(beans.iterator().next());
    }

    public <T> Manager removeObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        this.eventManager.removeObserver(observer, eventType, bindings);
        return this;
    }

    public <T> Manager removeObserver(Observer<T> observer, TypeLiteral<T> eventType, Annotation ... bindings) {
        this.eventManager.removeObserver(observer, (Class)eventType.getType(), bindings);
        return this;
    }

    public Set<Bean<?>> resolveByName(String name) {
        return this.resolver.get(name);
    }

    public List<Decorator> resolveDecorators(Set<Class<?>> types, Annotation ... bindings) {
        return this.resolver.resolveDecorators(types, bindings);
    }

    public List<Interceptor> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        return this.resolver.resolveInterceptors(type, interceptorBindings);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Manager\n");
        buffer.append("Enabled deployment types: " + this.getEnabledDeploymentTypes() + "\n");
        buffer.append("Registered contexts: " + this.contextMap.keySet() + "\n");
        buffer.append("Registered beans: " + this.getBeans().size() + "\n");
        buffer.append("Registered decorators: " + this.decorators.size() + "\n");
        buffer.append("Registered interceptors: " + this.interceptors.size() + "\n");
        return buffer.toString();
    }

    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Strings.collectionToString("Enabled deployment types: ", this.getEnabledDeploymentTypes()));
        buffer.append(this.eventManager.toString() + "\n");
        buffer.append(MetaDataCache.instance().toString() + "\n");
        buffer.append(this.resolver.toString() + "\n");
        buffer.append(this.contextMap.toString() + "\n");
        buffer.append(this.proxyPool.toString() + "\n");
        buffer.append(Strings.collectionToString("Registered beans: ", this.getBeans()));
        buffer.append(Strings.collectionToString("Registered decorators: ", this.decorators));
        buffer.append(Strings.collectionToString("Registered interceptors: ", this.interceptors));
        return buffer.toString();
    }

    public Manager parse(InputStream xmlStream) {
        return null;
    }

    public Manager validate() {
        return null;
    }

    public Manager createChildManager() {
        return null;
    }

    public Manager setCurrent() {
        return null;
    }
}

