/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import javax.webbeans.DefinitionException;
import javax.webbeans.Dependent;
import javax.webbeans.IllegalProductException;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProducerBean<T, S>
extends AbstractBean<T, S> {
    protected AbstractClassBean<?> declaringBean;

    public AbstractProducerBean(AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        super(manager);
        this.declaringBean = declaringBean;
    }

    @Override
    protected Class<? extends Annotation> getDefaultDeploymentType() {
        this.deploymentType = this.declaringBean.getDeploymentType();
        return this.deploymentType;
    }

    @Override
    protected void initApiTypes() {
        if (this.getType().isArray() || this.getType().isPrimitive()) {
            this.apiTypes = new HashSet();
            this.apiTypes.add(this.getType());
            this.apiTypes.add(Object.class);
        } else if (this.getType().isInterface()) {
            super.initApiTypes();
            this.apiTypes.add(Object.class);
        } else {
            super.initApiTypes();
        }
    }

    @Override
    protected void initType() {
        try {
            if (this.getAnnotatedItem() != null) {
                this.type = this.getAnnotatedItem().getType();
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException(" Cannot cast producer type " + this.getAnnotatedItem().getType() + " to bean type " + (this.getDeclaredBeanType() == null ? " unknown " : this.getDeclaredBeanType()), e);
        }
    }

    public AbstractClassBean<?> getDeclaringBean() {
        return this.declaringBean;
    }

    protected void checkProducerReturnType() {
        for (Type type : this.getAnnotatedItem().getActualTypeArguments()) {
            if (type instanceof Class) continue;
            throw new DefinitionException("Producer type cannot be parameterized with type parameter or wildcard");
        }
    }

    @Override
    protected void init() {
        super.init();
        this.checkProducerReturnType();
    }

    protected void checkReturnValue(T instance) {
        if (instance == null && !this.getScopeType().equals(Dependent.class)) {
            throw new IllegalProductException("Cannot return null from a non-dependent producer method");
        }
    }

    protected Object getReceiver() {
        return this.getAnnotatedItem().isStatic() ? null : this.manager.getInstance(this.getDeclaringBean());
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Annotated " + Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed producer bean");
        } else {
            buffer.append("simple producer bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "]\n");
        buffer.append("   API types " + this.getTypes() + ", binding types " + this.getBindingTypes() + "\n");
        return buffer.toString();
    }
}

