/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.proxy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.webbeans.DefinitionException;
import javax.webbeans.manager.Bean;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bean.proxy.ProxyMethodHandler;
import org.jboss.webbeans.util.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyPool {
    private ConcurrentCache<Bean<? extends Object>, Object> pool = new ConcurrentCache();

    private static TypeInfo getTypeInfo(Set<Class<?>> types) {
        TypeInfo typeInfo = new TypeInfo();
        ArrayList interfaces = new ArrayList();
        Class<?> superclass = null;
        for (Class<?> type : types) {
            if (type.isInterface()) {
                interfaces.add(type);
                continue;
            }
            if (superclass != null && (type == Object.class || !superclass.isAssignableFrom(type))) continue;
            superclass = type;
        }
        interfaces.add(Serializable.class);
        typeInfo.interfaces = interfaces.toArray(new Class[0]);
        typeInfo.superclass = superclass;
        return typeInfo;
    }

    private static <T> T createClientProxy(Bean<T> bean, int beanIndex) throws RuntimeException {
        Object clientProxy;
        ProxyFactory proxyFactory = new ProxyFactory();
        TypeInfo typeInfo = ProxyPool.getTypeInfo(bean.getTypes());
        proxyFactory.setInterfaces((Class[])typeInfo.interfaces);
        proxyFactory.setSuperclass(typeInfo.superclass);
        try {
            clientProxy = proxyFactory.createClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate client proxy for " + bean, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access bean correctly when creating client proxy for " + bean, e);
        }
        ProxyMethodHandler proxyMethodHandler = new ProxyMethodHandler(bean, beanIndex);
        ((ProxyObject)clientProxy).setHandler((MethodHandler)proxyMethodHandler);
        return clientProxy;
    }

    public <T> T getClientProxy(final Bean<T> bean) {
        return (T)this.pool.putIfAbsent(bean, new Callable<T>(){

            @Override
            public T call() throws Exception {
                int beanIndex = CurrentManager.rootManager().getBeans().indexOf(bean);
                if (beanIndex < 0) {
                    throw new DefinitionException(bean + " is not known to the manager");
                }
                return ProxyPool.createClientProxy(bean, beanIndex);
            }
        });
    }

    public String toString() {
        return "Proxy pool with " + this.pool.size() + " proxies";
    }

    private static class TypeInfo {
        Class<?>[] interfaces;
        Class<?> superclass;

        private TypeInfo() {
        }
    }
}

