/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.webbeans.DefinitionException;
import javax.webbeans.Observable;
import javax.webbeans.Observer;
import javax.webbeans.Observes;
import javax.webbeans.Obtainable;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.BeanFactory;
import org.jboss.webbeans.bean.EventBean;
import org.jboss.webbeans.bean.InstanceBean;
import org.jboss.webbeans.bean.ProducerFieldBean;
import org.jboss.webbeans.bean.ProducerMethodBean;
import org.jboss.webbeans.bindings.InitializedBinding;
import org.jboss.webbeans.bootstrap.DeploymentProperties;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.contexts.DependentContext;
import org.jboss.webbeans.ejb.DefaultEnterpriseBeanLookup;
import org.jboss.webbeans.ejb.EJB;
import org.jboss.webbeans.ejb.EjbDescriptorCache;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.jsf.JSF;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.Servlet;
import org.jboss.webbeans.transaction.Transaction;
import org.jboss.webbeans.util.JNDI;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeansBootstrap {
    public static String WEB_BEAN_DISCOVERY_PROPERTY_NAME = "org.jboss.webbeans.bootstrap.webBeanDiscovery";
    private static LogProvider log = Logging.getLogProvider(WebBeansBootstrap.class);
    protected ManagerImpl manager;

    public WebBeansBootstrap(ManagerImpl manager) {
        this.manager = manager;
        CurrentManager.setRootManager(manager);
        manager.addContext(DependentContext.INSTANCE);
        JNDI.set("java:comp/Manager", manager);
    }

    public WebBeansBootstrap() {
        this(new ManagerImpl());
    }

    protected void registerBeans(Class<?> ... classes) {
        this.registerBeans(new HashSet(Arrays.asList(classes)));
    }

    protected void registerBeans(Iterable<Class<?>> classes) {
        Set<AbstractBean<?, ?>> beans = this.createBeans(classes);
        beans.addAll(this.createStandardBeans());
        this.manager.setBeans(beans);
    }

    protected Set<AbstractBean<?, ?>> createStandardBeans() {
        HashSet beans = new HashSet();
        this.createBean(BeanFactory.createSimpleBean(Transaction.class, this.manager), beans);
        this.createBean(BeanFactory.createSimpleBean(ManagerImpl.class, this.manager), beans);
        this.createBean(BeanFactory.createSimpleBean(DefaultEnterpriseBeanLookup.class, this.manager), beans);
        return beans;
    }

    protected Set<AbstractBean<?, ?>> createBeans(Iterable<Class<?>> classes) {
        HashSet beans = new HashSet();
        for (Class<?> clazz : classes) {
            if (EjbDescriptorCache.instance().containsKey(clazz)) {
                this.createBean(BeanFactory.createEnterpriseBean(clazz, this.manager), beans);
                continue;
            }
            if (!WebBeansBootstrap.isTypeSimpleWebBean(clazz)) continue;
            this.createBean(BeanFactory.createSimpleBean(clazz, this.manager), beans);
        }
        return beans;
    }

    protected void createBean(AbstractClassBean<?> bean, Set<AbstractBean<?, ?>> beans) {
        beans.add(bean);
        this.manager.getResolver().addInjectionPoints(bean.getInjectionPoints());
        for (AnnotatedMethod<Object> annotatedMethod : bean.getProducerMethods()) {
            ProducerMethodBean<Object> producerMethodBean = BeanFactory.createProducerMethodBean(annotatedMethod, bean, this.manager);
            beans.add(producerMethodBean);
            this.manager.getResolver().addInjectionPoints(producerMethodBean.getInjectionPoints());
            log.info("Web Bean: " + producerMethodBean);
        }
        for (AnnotatedField annotatedField : bean.getProducerFields()) {
            ProducerFieldBean producerFieldBean = BeanFactory.createProducerFieldBean(annotatedField, bean, this.manager);
            beans.add(producerFieldBean);
            log.info("Web Bean: " + producerFieldBean);
        }
        for (AnnotatedItem<Object, Method> annotatedItem : bean.getInjectionPoints()) {
            if (annotatedItem.isAnnotationPresent(Observable.class)) {
                EventBean eventBean = BeanFactory.createEventBean(annotatedItem, this.manager);
                beans.add(eventBean);
                log.info("Web Bean: " + eventBean);
            }
            if (!annotatedItem.isAnnotationPresent(Obtainable.class)) continue;
            InstanceBean instanceBean = BeanFactory.createInstanceBean(annotatedItem, this.manager);
            beans.add(instanceBean);
            log.info("Web Bean: " + instanceBean);
        }
        for (AnnotatedMethod annotatedMethod : bean.getObserverMethods()) {
            ObserverImpl observer = BeanFactory.createObserver(annotatedMethod, bean, this.manager);
            if (annotatedMethod.getAnnotatedParameters(Observes.class).size() == 1) {
                this.registerObserver(observer, annotatedMethod.getAnnotatedParameters(Observes.class).get(0).getType(), annotatedMethod.getAnnotatedParameters(Observes.class).get(0).getBindingTypesAsArray());
                continue;
            }
            throw new DefinitionException("Observer method can only have one parameter annotated @Observes " + observer);
        }
        log.info("Web Bean: " + bean);
    }

    public void boot(WebBeanDiscovery webBeanDiscovery) {
        log.info("Starting Web Beans RI " + WebBeansBootstrap.getVersion());
        if (webBeanDiscovery == null) {
            throw new IllegalStateException("No WebBeanDiscovery provider found, you need to implement the org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery interface, and tell the RI to use it by specifying -D" + WEB_BEAN_DISCOVERY_PROPERTY_NAME + "=<classname>");
        }
        EjbDescriptorCache.instance().addAll(webBeanDiscovery.discoverEjbs());
        this.registerBeans(webBeanDiscovery.discoverWebBeanClasses());
        log.info("Validing Web Bean injection points");
        this.manager.getResolver().resolveInjectionPoints();
        this.manager.fireEvent(this.manager, new Annotation[]{new InitializedBinding()});
        log.info("Web Beans RI initialized");
    }

    public static String getVersion() {
        Package pkg = WebBeansBootstrap.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    public static Set<Class<? extends WebBeanDiscovery>> getWebBeanDiscoveryClasses() {
        HashSet<Class<? extends WebBeanDiscovery>> webBeanDiscoveryClasses = new HashSet<Class<? extends WebBeanDiscovery>>();
        for (String className : new DeploymentProperties(Thread.currentThread().getContextClassLoader()).getPropertyValues(WEB_BEAN_DISCOVERY_PROPERTY_NAME)) {
            try {
                webBeanDiscoveryClasses.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                log.debug("Unable to load WebBeanDiscovery provider " + className, e);
            }
            catch (NoClassDefFoundError e) {
                log.warn("Unable to load WebBeanDiscovery provider " + className + " due classDependencyProblem", e);
            }
        }
        return webBeanDiscoveryClasses;
    }

    private <T> void registerObserver(Observer<T> observer, Class<?> eventType, Annotation[] bindings) {
        this.manager.addObserver(observer, eventType, bindings);
    }

    protected static boolean isTypeSimpleWebBean(Class<?> type) {
        return !type.isAnnotation() && !Reflections.isAbstract(type) && !Servlet.SERVLET_CLASS.isAssignableFrom(type) && !Servlet.FILTER_CLASS.isAssignableFrom(type) && !Servlet.SERVLET_CONTEXT_LISTENER_CLASS.isAssignableFrom(type) && !Servlet.HTTP_SESSION_LISTENER_CLASS.isAssignableFrom(type) && !Servlet.SERVLET_REQUEST_LISTENER_CLASS.isAssignableFrom(type) && !EJB.ENTERPRISE_BEAN_CLASS.isAssignableFrom(type) && !JSF.UICOMPONENT_CLASS.isAssignableFrom(type);
    }
}

