/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.contexts;

import java.lang.annotation.Annotation;
import javax.webbeans.ContextNotActiveException;
import javax.webbeans.manager.Context;
import javax.webbeans.manager.Contextual;
import org.jboss.webbeans.contexts.BeanMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext
implements Context {
    private Class<? extends Annotation> scopeType;
    private ThreadLocal<Boolean> active;

    public AbstractContext(Class<? extends Annotation> scopeType) {
        this.scopeType = scopeType;
        this.active = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.TRUE;
            }
        };
    }

    public <T> T get(Contextual<T> bean, boolean create) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        Object instance = this.getBeanMap().get(bean);
        if (instance != null) {
            return instance;
        }
        if (!create) {
            return null;
        }
        instance = bean.create();
        this.getBeanMap().put(bean, instance);
        return instance;
    }

    public Class<? extends Annotation> getScopeType() {
        return this.scopeType;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void setActive(boolean active) {
        this.active.set(active);
    }

    private <T> void destroy(Contextual<T> bean) {
        bean.destroy(this.getBeanMap().get(bean));
    }

    public void destroy() {
        for (Contextual<? extends Object> bean : this.getBeanMap().keySet()) {
            this.destroy(bean);
        }
        this.getBeanMap().clear();
    }

    protected abstract BeanMap getBeanMap();

    protected Boolean getActive() {
        return this.active.get();
    }
}

