/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.contexts;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.webbeans.manager.Context;
import org.jboss.webbeans.contexts.AbstractContext;
import org.jboss.webbeans.util.ConcurrentCache;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMap
extends ConcurrentCache<Class<? extends Annotation>, List<Context>> {
    public AbstractContext getBuiltInContext(Class<? extends Annotation> scopeType) {
        boolean interrupted = false;
        while (true) {
            try {
                Future future = this.getFuture(scopeType);
                if (future == null) {
                    AbstractContext abstractContext = null;
                    return abstractContext;
                }
                AbstractContext abstractContext = (AbstractContext)((List)future.get()).iterator().next();
                return abstractContext;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                this.rethrow(e);
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public List<Context> getContext(Class<? extends Annotation> scopeType) {
        boolean interrupted = false;
        while (true) {
            try {
                List list = (List)this.getFuture(scopeType).get();
                return list;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                this.rethrow(e);
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String toString() {
        return "ContextMap holding " + this.delegate().size() + " contexts: " + this.delegate().keySet();
    }

    public String toDetailedString() {
        return Strings.mapToString("ContextMap (scope type -> context list): ", this.delegate());
    }

    public void add(Context context) {
        List<Context> contexts = this.putIfAbsent(context.getScopeType(), new Callable<List<Context>>(){

            @Override
            public List<Context> call() throws Exception {
                return new CopyOnWriteArrayList<Context>();
            }
        });
        contexts.add(context);
    }
}

