/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.contexts;

import java.util.concurrent.atomic.AtomicInteger;
import javax.webbeans.ContextNotActiveException;
import javax.webbeans.Dependent;
import javax.webbeans.manager.Contextual;
import org.jboss.webbeans.contexts.BasicContext;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentContext
extends BasicContext {
    public static final DependentContext INSTANCE = new DependentContext();
    private ThreadLocal<AtomicInteger> reentrantActiveCount;

    public DependentContext() {
        super(Dependent.class);
        super.setActive(false);
        this.reentrantActiveCount = new ThreadLocal<AtomicInteger>(){

            @Override
            protected AtomicInteger initialValue() {
                return new AtomicInteger(0);
            }
        };
    }

    @Override
    public <T> T get(Contextual<T> bean, boolean create) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        return (T)(!create ? null : bean.create());
    }

    public String toString() {
        String active = this.isActive() ? "Active " : "Inactive ";
        String count = this.getBeanMap() == null ? "" : "holding " + Names.count(this.getBeanMap().keySet()) + " instances ";
        return active + "dependent context " + count;
    }

    @Override
    public void setActive(boolean active) {
        if (active) {
            if (this.reentrantActiveCount.get().incrementAndGet() == 1) {
                super.setActive(true);
            }
        } else if (this.reentrantActiveCount.get().decrementAndGet() == 0) {
            super.setActive(false);
        }
    }
}

