/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.ejb;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.webbeans.bootstrap.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDescriptorCache {
    private static EjbDescriptorCache instance = new EjbDescriptorCache();
    private ConcurrentMap<String, EjbDescriptor<?>> ejbsByName = new ConcurrentHashMap();
    private ConcurrentMap<Class<?>, Set<EjbDescriptor<?>>> ejbsByBeanClass = new ConcurrentHashMap();

    public static EjbDescriptorCache instance() {
        return instance;
    }

    public EjbDescriptor<?> get(String ejbName) {
        return (EjbDescriptor)this.ejbsByName.get(ejbName);
    }

    public Iterable<EjbDescriptor<?>> get(Class<?> beanClass) {
        return (Iterable)this.ejbsByBeanClass.get(beanClass);
    }

    public void add(EjbDescriptor<?> ejbDescriptor) {
        this.ejbsByName.put(ejbDescriptor.getEjbName(), ejbDescriptor);
        this.ejbsByBeanClass.putIfAbsent(ejbDescriptor.getType(), new CopyOnWriteArraySet());
        ((Set)this.ejbsByBeanClass.get(ejbDescriptor.getType())).add(ejbDescriptor);
    }

    public boolean containsKey(String ejbName) {
        return this.ejbsByName.containsKey(ejbName);
    }

    public boolean containsKey(Class<?> beanClass) {
        return this.ejbsByBeanClass.containsKey(beanClass);
    }

    public void addAll(Iterable<EjbDescriptor<?>> ejbDescriptors) {
        for (EjbDescriptor<?> ejbDescriptor : ejbDescriptors) {
            this.add(ejbDescriptor);
        }
    }
}

