/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import com.google.common.collect.ForwardingMap;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.SystemException;
import javax.webbeans.Observer;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.contexts.DependentContext;
import org.jboss.webbeans.event.DeferredEventNotification;
import org.jboss.webbeans.event.EventObserver;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.transaction.UserTransaction;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    private ManagerImpl manager;
    private final RegisteredObserversMap registeredObservers;

    public EventManager(ManagerImpl manager) {
        this.manager = manager;
        this.registeredObservers = new RegisteredObserversMap();
    }

    public <T> void addObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        EventObserver<T> eventObserver = new EventObserver<T>(observer, eventType, bindings);
        this.registeredObservers.put(eventType, eventObserver);
    }

    public <T> Set<Observer<T>> getObservers(T event, Annotation ... bindings) {
        HashSet<Observer<T>> interestedObservers = new HashSet<Observer<T>>();
        for (Class<?> clazz : Reflections.getTypeHierachy(event.getClass())) {
            Iterator i$ = ((CopyOnWriteArrayList)this.registeredObservers.get(clazz)).iterator();
            while (i$.hasNext()) {
                EventObserver observer = (EventObserver)i$.next();
                if (!observer.isObserverInterested(bindings)) continue;
                interestedObservers.add(observer.getObserver());
            }
        }
        return interestedObservers;
    }

    private boolean isTransactionActive() {
        UserTransaction userTransaction = this.manager.getInstanceByType(UserTransaction.class, new Annotation[0]);
        try {
            return userTransaction != null && userTransaction.getStatus() == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void notifyObservers(Set<Observer<T>> observers, T event) {
        try {
            DependentContext.INSTANCE.setActive(true);
            for (Observer<T> observer : observers) {
                if (this.isTransactionActive() && ((ObserverImpl)observer).isTransactional()) {
                    this.deferEvent(event, observer);
                    continue;
                }
                observer.notify(event);
            }
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    private <T> void deferEvent(T event, Observer<T> observer) {
        UserTransaction userTransaction = this.manager.getInstanceByType(UserTransaction.class, new Annotation[0]);
        DeferredEventNotification<T> deferredEvent = new DeferredEventNotification<T>(event, observer);
        userTransaction.registerSynchronization(deferredEvent);
    }

    public <T> void removeObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        Object observers = this.registeredObservers.get(eventType);
        EventObserver<T> eventObserver = new EventObserver<T>(observer, eventType, bindings);
        observers.remove(eventObserver);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Event manager\n");
        buffer.append(this.registeredObservers.toString());
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegisteredObserversMap
    extends ForwardingMap<Class<?>, List<EventObserver<?>>> {
        private Map<Class<?>, List<EventObserver<?>>> delegate = new ConcurrentHashMap();

        protected Map<Class<?>, List<EventObserver<?>>> delegate() {
            return this.delegate;
        }

        public CopyOnWriteArrayList<EventObserver<?>> get(Object eventType) {
            CopyOnWriteArrayList observers = (CopyOnWriteArrayList)super.get(eventType);
            return observers != null ? observers : new CopyOnWriteArrayList();
        }

        public void put(Class<?> eventType, EventObserver<?> observer) {
            CopyOnWriteArrayList observers = (CopyOnWriteArrayList)super.get(eventType);
            if (observers == null) {
                observers = new CopyOnWriteArrayList();
                super.put(eventType, observers);
            }
            if (!observers.contains(observer)) {
                observers.add(observer);
            }
        }

        public String toString() {
            return Strings.mapToString("RegisteredObserversMap (event type -> observers list): ", this.delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TransactionObservationPhase {
        NONE,
        BEFORE_COMPLETION,
        AFTER_COMPLETION,
        AFTER_FAILURE,
        AFTER_SUCCESS;

    }
}

