/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.collect.ForwardingMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.webbeans.BindingType;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedItem;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedMember<T, S extends Member>
extends AbstractAnnotatedItem<T, S> {
    private final String name;
    private String toString;

    public AbstractAnnotatedMember(AbstractAnnotatedItem.AnnotationMap annotationMap, Member member) {
        super(annotationMap);
        this.name = member.getName();
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic((Member)this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal((Member)this.getDelegate());
    }

    public T getValue(Manager manager) {
        return (T)manager.getInstanceByType(this.getType(), this.getMetaAnnotationsAsArray(BindingType.class));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated member " + this.getName();
        return this.toString;
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AbstractAnnotatedMember:\n");
        buffer.append(super.toString() + "\n");
        buffer.append("Final: " + this.isFinal() + "\n");
        buffer.append("Static: " + this.isStatic() + "\n");
        buffer.append("Name: " + this.getName() + "\n");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AnnotatedParameterMap
    extends ForwardingMap<Class<? extends Annotation>, List<AnnotatedParameter<Object>>> {
        private Map<Class<? extends Annotation>, List<AnnotatedParameter<Object>>> delegate = new HashMap<Class<? extends Annotation>, List<AnnotatedParameter<Object>>>();

        protected Map<Class<? extends Annotation>, List<AnnotatedParameter<Object>>> delegate() {
            return this.delegate;
        }

        public void put(Class<? extends Annotation> key, AnnotatedParameter<Object> value) {
            ArrayList<AnnotatedParameter<Object>> parameters = (ArrayList<AnnotatedParameter<Object>>)super.get(key);
            if (parameters == null) {
                parameters = new ArrayList<AnnotatedParameter<Object>>();
                super.put(key, parameters);
            }
            parameters.add(value);
        }

        public String toString() {
            return Strings.mapToString("AnnotatedParameterMap (annotation type -> parameter abstraction list): ", this.delegate);
        }

        public List<AnnotatedParameter<Object>> get(Object key) {
            List parameters = (List)super.get(key);
            return parameters != null ? parameters : new ArrayList();
        }
    }
}

