/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.collect.ForwardingMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedType;
import org.jboss.webbeans.introspector.jlr.AnnotatedConstructorImpl;
import org.jboss.webbeans.introspector.jlr.AnnotatedFieldImpl;
import org.jboss.webbeans.introspector.jlr.AnnotatedMethodImpl;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedClassImpl<T>
extends AbstractAnnotatedType<T>
implements AnnotatedClass<T> {
    private final Class<T> clazz;
    private final Type[] actualTypeArguments;
    private final Set<AnnotatedField<Object>> fields;
    private final AnnotatedFieldMap annotatedFields;
    private final AnnotatedFieldMap metaAnnotatedFields;
    private final Set<AnnotatedMethod<Object>> methods;
    private final AnnotatedMethodMap annotatedMethods;
    private final AnnotatedMethodMap methodsByAnnotatedParameters;
    private final Set<AnnotatedConstructor<T>> constructors;
    private final AnnotatedConstructorMap annotatedConstructors;
    private final ConstructorsByArgumentMap constructorsByArgumentMap;
    private String toString;

    public AnnotatedClassImpl(Class<T> rawType, Type type, Annotation[] annotations) {
        super(AnnotatedClassImpl.buildAnnotationMap(annotations), rawType);
        Class<T> c;
        this.clazz = rawType;
        this.actualTypeArguments = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments() : new Type[0];
        this.fields = new HashSet<AnnotatedField<Object>>();
        this.annotatedFields = new AnnotatedFieldMap();
        this.metaAnnotatedFields = new AnnotatedFieldMap();
        for (c = this.clazz; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Field field : this.clazz.getDeclaredFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                AnnotatedFieldImpl<Object> annotatedField = new AnnotatedFieldImpl<Object>(field, this);
                this.fields.add(annotatedField);
                for (Annotation annotation : annotatedField.getAnnotations()) {
                    this.annotatedFields.put(annotation.annotationType(), annotatedField);
                    for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.metaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                    }
                }
            }
        }
        this.constructors = new HashSet<AnnotatedConstructor<T>>();
        this.constructorsByArgumentMap = new ConstructorsByArgumentMap();
        this.annotatedConstructors = new AnnotatedConstructorMap();
        for (Constructor<?> constructor : this.clazz.getDeclaredConstructors()) {
            AnnotatedConstructorImpl annotatedConstructor = new AnnotatedConstructorImpl(constructor, this);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            this.constructors.add(annotatedConstructor);
            this.constructorsByArgumentMap.put(Arrays.asList(constructor.getParameterTypes()), annotatedConstructor);
            for (Annotation annotation : annotatedConstructor.getAnnotations()) {
                if (!this.annotatedConstructors.containsKey(annotation.annotationType())) {
                    this.annotatedConstructors.put(annotation.annotationType(), new HashSet());
                }
                this.annotatedConstructors.get(annotation.annotationType()).add(annotatedConstructor);
            }
        }
        this.methods = new HashSet<AnnotatedMethod<Object>>();
        this.annotatedMethods = new AnnotatedMethodMap();
        this.methodsByAnnotatedParameters = new AnnotatedMethodMap();
        for (c = this.clazz; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Method method : this.clazz.getDeclaredMethods()) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                AnnotatedMethodImpl<Object> annotatedMethod = new AnnotatedMethodImpl<Object>(method, this);
                this.methods.add(annotatedMethod);
                for (Annotation annotation : annotatedMethod.getAnnotations()) {
                    if (!this.annotatedMethods.containsKey(annotation.annotationType())) {
                        this.annotatedMethods.put(annotation.annotationType(), new HashSet());
                    }
                    this.annotatedMethods.get(annotation.annotationType()).add(annotatedMethod);
                }
                for (Class clazz : AnnotatedMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (annotatedMethod.getAnnotatedParameters(clazz).size() <= 0) continue;
                    this.methodsByAnnotatedParameters.put(clazz, annotatedMethod);
                }
            }
        }
    }

    public AnnotatedClassImpl(Class<T> clazz) {
        this(clazz, clazz, clazz.getAnnotations());
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.clazz;
    }

    @Override
    public Class<T> getDelegate() {
        return this.clazz;
    }

    @Override
    public Set<AnnotatedField<Object>> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    @Override
    public Set<AnnotatedField<Object>> getMetaAnnotatedFields(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.metaAnnotatedFields.get(metaAnnotationType));
    }

    @Override
    public Set<AnnotatedField<Object>> getAnnotatedFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedFields.get(annotationType));
    }

    @Override
    public Class<T> getType() {
        return this.clazz;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Set<AnnotatedMethod<Object>> getAnnotatedMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMethods.get(annotationType));
    }

    @Override
    public Set<AnnotatedConstructor<T>> getAnnotatedConstructors(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedConstructors.get(annotationType));
    }

    @Override
    public AnnotatedConstructor<T> getConstructor(List<Class<?>> arguments) {
        return (AnnotatedConstructor)this.constructorsByArgumentMap.get(arguments);
    }

    @Override
    public Set<AnnotatedMethod<Object>> getMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return this.methodsByAnnotatedParameters.get(annotationType);
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated class " + Names.class2String(this.getDelegate());
        return this.toString;
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AnnotatedConstructorImpl:\n");
        buffer.append(super.toString() + "\n");
        buffer.append(Strings.collectionToString("Actual type arguments: ", Arrays.asList(this.getActualTypeArguments())));
        buffer.append("Class: " + this.clazz.toString() + "\n");
        buffer.append(Strings.collectionToString("Fields: ", this.getFields()));
        buffer.append(Strings.collectionToString("Methods: ", this.methods));
        buffer.append(Strings.collectionToString("Constructors: ", this.getConstructors()));
        buffer.append(this.annotatedConstructors == null ? "" : this.annotatedConstructors.toString() + "\n");
        buffer.append(this.annotatedFields == null ? "" : this.annotatedFields.toString() + "\n");
        buffer.append(this.annotatedMethods == null ? "" : this.annotatedMethods.toString() + "\n");
        buffer.append(this.constructorsByArgumentMap == null ? "" : this.constructorsByArgumentMap.toString() + "\n");
        buffer.append(this.metaAnnotatedFields == null ? "" : this.metaAnnotatedFields.toString() + "\n");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructorsByArgumentMap
    extends ForwardingMap<List<Class<?>>, AnnotatedConstructor<T>> {
        private Map<List<Class<?>>, AnnotatedConstructor<T>> delegate = new HashMap();

        protected Map<List<Class<?>>, AnnotatedConstructor<T>> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("Annotation type -> constructor by arguments mappings: ", this.delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedConstructorMap
    extends ForwardingMap<Class<? extends Annotation>, Set<AnnotatedConstructor<T>>> {
        private Map<Class<? extends Annotation>, Set<AnnotatedConstructor<T>>> delegate = new HashMap();

        protected Map<Class<? extends Annotation>, Set<AnnotatedConstructor<T>>> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("AnnotatedConstructorMap (annotation type -> constructor abstraction set): ", this.delegate);
        }

        public Set<AnnotatedConstructor<T>> get(Object key) {
            Set constructors = (Set)super.get(key);
            return constructors != null ? constructors : new HashSet();
        }

        public void add(Class<? extends Annotation> key, AnnotatedConstructor<T> value) {
            HashSet constructors = (HashSet)super.get(key);
            if (constructors == null) {
                constructors = new HashSet();
                super.put(key, constructors);
            }
            constructors.add(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedMethodMap
    extends ForwardingMap<Class<? extends Annotation>, Set<AnnotatedMethod<Object>>> {
        private Map<Class<? extends Annotation>, Set<AnnotatedMethod<Object>>> delegate = new HashMap<Class<? extends Annotation>, Set<AnnotatedMethod<Object>>>();

        protected Map<Class<? extends Annotation>, Set<AnnotatedMethod<Object>>> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("AnnotatedMethodMap (annotation type -> method abstraction set): ", this.delegate);
        }

        public Set<AnnotatedMethod<Object>> get(Object key) {
            Set methods = (Set)super.get(key);
            return methods != null ? methods : new HashSet();
        }

        public void put(Class<? extends Annotation> key, AnnotatedMethod<Object> value) {
            HashSet<AnnotatedMethod<Object>> methods = (HashSet<AnnotatedMethod<Object>>)super.get(key);
            if (methods == null) {
                methods = new HashSet<AnnotatedMethod<Object>>();
                super.put(key, methods);
            }
            methods.add(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotatedFieldMap
    extends ForwardingMap<Class<? extends Annotation>, Set<AnnotatedField<Object>>> {
        private Map<Class<? extends Annotation>, Set<AnnotatedField<Object>>> delegate = new HashMap<Class<? extends Annotation>, Set<AnnotatedField<Object>>>();

        protected Map<Class<? extends Annotation>, Set<AnnotatedField<Object>>> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("AnnotatedFieldMap (annotation type -> field abstraction set): ", this.delegate);
        }

        public Set<AnnotatedField<Object>> get(Object key) {
            Set fields = (Set)super.get(key);
            return fields != null ? fields : new HashSet();
        }

        public void put(Class<? extends Annotation> key, AnnotatedField<Object> value) {
            HashSet<AnnotatedField<Object>> fields = (HashSet<AnnotatedField<Object>>)super.get(key);
            if (fields == null) {
                fields = new HashSet<AnnotatedField<Object>>();
                super.put(key, fields);
            }
            fields.add(value);
        }
    }
}

