/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.webbeans.manager.Manager;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.AnnotatedType;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedMember;
import org.jboss.webbeans.introspector.jlr.AnnotatedParameterImpl;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedMethodImpl<T>
extends AbstractAnnotatedMember<T, Method>
implements AnnotatedMethod<T> {
    private final Type[] actualTypeArguments;
    private final Method method;
    private final List<AnnotatedParameter<Object>> parameters;
    private final AbstractAnnotatedMember.AnnotatedParameterMap annotatedParameters;
    private final String propertyName;
    private final AnnotatedType<?> declaringClass;
    private String toString;

    public AnnotatedMethodImpl(Method method, AnnotatedType<?> declaringClass) {
        super(AnnotatedMethodImpl.buildAnnotationMap(method), method);
        this.method = method;
        this.declaringClass = declaringClass;
        this.actualTypeArguments = method.getGenericReturnType() instanceof ParameterizedType ? ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments() : new Type[0];
        this.parameters = new ArrayList<AnnotatedParameter<Object>>();
        this.annotatedParameters = new AbstractAnnotatedMember.AnnotatedParameterMap();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            AnnotatedParameterImpl<Object> parameter;
            Class<?> clazz;
            if (method.getParameterAnnotations()[i].length > 0) {
                clazz = method.getParameterTypes()[i];
                parameter = new AnnotatedParameterImpl(method.getParameterAnnotations()[i], clazz);
                this.parameters.add(parameter);
                for (Annotation annotation : parameter.getAnnotations()) {
                    if (!MAPPED_PARAMETER_ANNOTATIONS.contains(annotation.annotationType())) continue;
                    this.annotatedParameters.put(annotation.annotationType(), parameter);
                }
                continue;
            }
            clazz = method.getParameterTypes()[i];
            parameter = new AnnotatedParameterImpl<Object>(new Annotation[0], clazz);
            this.parameters.add(parameter);
        }
        String propertyName = Reflections.getPropertyName(this.getDelegate());
        this.propertyName = propertyName == null ? this.getName() : propertyName;
    }

    public Method getAnnotatedMethod() {
        return this.method;
    }

    @Override
    public Method getDelegate() {
        return this.method;
    }

    @Override
    public Class<T> getType() {
        return this.method.getReturnType();
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public List<AnnotatedParameter<Object>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<AnnotatedParameter<Object>> getAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableList(this.annotatedParameters.get(annotationType));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AnnotatedMethod) {
            AnnotatedMethod that = (AnnotatedMethod)other;
            return this.getDeclaringClass().equals(that.getDeclaringClass()) && this.getName().equals(that.getName()) && ((Object)this.getParameters()).equals(that.getParameters());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public T invoke(Object instance, Manager manager) {
        return (T)Reflections.invokeAndWrap(this.getDelegate(), instance, AnnotatedMethodImpl.getParameterValues(this.parameters, manager));
    }

    @Override
    public T invokeWithSpecialValue(Object instance, Class<? extends Annotation> specialParam, Object specialVal, Manager manager) {
        return (T)Reflections.invokeAndWrap(this.getDelegate(), instance, AnnotatedMethodImpl.getParameterValues(this.parameters, specialVal, specialParam, manager));
    }

    @Override
    public T invoke(Object instance, Object ... parameters) {
        return (T)Reflections.invokeAndWrap(this.getDelegate(), instance, parameters);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public AnnotatedType<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated method " + Names.method2String(this.method);
        return this.toString;
    }

    @Override
    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AnnotatedMethodImpl:\n");
        buffer.append(super.toString() + "\n");
        buffer.append(Strings.collectionToString("Actual type arguments: ", Arrays.asList(this.getActualTypeArguments())));
        buffer.append(this.annotatedParameters == null ? "" : this.annotatedParameters.toString() + "\n");
        buffer.append("Declaring class:\n");
        buffer.append(this.declaringClass.getName() + "[ " + this.declaringClass.getType() + "]" + "\n");
        buffer.append("Method:\n");
        buffer.append(this.method.toString());
        buffer.append("Property name: " + this.propertyName + "\n");
        buffer.append(Strings.collectionToString("Parameters: ", this.getParameters()));
        return buffer.toString();
    }
}

