/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.model;

import java.lang.annotation.Annotation;
import javax.webbeans.DefinitionException;
import org.jboss.webbeans.introspector.AnnotatedAnnotation;
import org.jboss.webbeans.introspector.jlr.AnnotatedAnnotationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationModel<T extends Annotation> {
    private AnnotatedAnnotation<T> annotatedAnnotation;
    private boolean valid;

    public AnnotationModel(Class<T> type) {
        this.annotatedAnnotation = new AnnotatedAnnotationImpl<T>(type);
        this.init();
    }

    protected void init() {
        this.initType();
        this.initValid();
    }

    protected void initType() {
        if (!Annotation.class.isAssignableFrom(this.getType())) {
            throw new DefinitionException(this.getMetaAnnotation().toString() + " can only be applied to an annotation, it was applied to " + this.getType());
        }
    }

    protected void initValid() {
        this.valid = this.annotatedAnnotation.isAnnotationPresent(this.getMetaAnnotation());
    }

    public Class<T> getType() {
        return this.annotatedAnnotation.getType();
    }

    protected abstract Class<? extends Annotation> getMetaAnnotation();

    public boolean isValid() {
        return this.valid;
    }

    protected AnnotatedAnnotation<T> getAnnotatedAnnotation() {
        return this.annotatedAnnotation;
    }

    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " annotation model for " + this.getType();
    }

    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AnnotationModel:\n");
        buffer.append("Annotated annotation: " + this.getAnnotatedAnnotation().toString());
        buffer.append("Valid: " + this.isValid());
        return buffer.toString();
    }
}

