/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.model;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.jboss.webbeans.MetaDataCache;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedItem;
import org.jboss.webbeans.model.StereotypeModel;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedStereotypes<T, E> {
    private AbstractAnnotatedItem.AnnotationMap possibleDeploymentTypes = new AbstractAnnotatedItem.AnnotationMap();
    private Set<Annotation> possibleScopeTypes = new HashSet<Annotation>();
    private boolean beanNameDefaulted;
    private Set<Class<?>> requiredTypes = new HashSet();
    private Set<Class<? extends Annotation>> supportedScopes = new HashSet<Class<? extends Annotation>>();

    public MergedStereotypes(Set<Annotation> stereotypeAnnotations) {
        this.merge(stereotypeAnnotations);
    }

    protected void merge(Set<Annotation> stereotypeAnnotations) {
        for (Annotation stereotypeAnnotation : stereotypeAnnotations) {
            StereotypeModel<? extends Annotation> stereotype = MetaDataCache.instance().getStereotype(stereotypeAnnotation.annotationType());
            if (stereotype == null) {
                throw new IllegalStateException("Stereotype " + stereotypeAnnotation + " not registered with container");
            }
            if (stereotype.getDefaultDeploymentType() != null) {
                this.possibleDeploymentTypes.put(stereotype.getDefaultDeploymentType().annotationType(), stereotype.getDefaultDeploymentType());
            }
            if (stereotype.getDefaultScopeType() != null) {
                this.possibleScopeTypes.add(stereotype.getDefaultScopeType());
            }
            this.requiredTypes.addAll(stereotype.getRequiredTypes());
            this.supportedScopes.addAll(stereotype.getSupportedScopes());
            if (!stereotype.isBeanNameDefaulted()) continue;
            this.beanNameDefaulted = true;
        }
    }

    public AbstractAnnotatedItem.AnnotationMap getPossibleDeploymentTypes() {
        return this.possibleDeploymentTypes;
    }

    public Set<Annotation> getPossibleScopeTypes() {
        return this.possibleScopeTypes;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    public Set<Class<?>> getRequiredTypes() {
        return this.requiredTypes;
    }

    public Set<Class<? extends Annotation>> getSupportedScopes() {
        return this.supportedScopes;
    }

    public boolean isDeclaredInXml() {
        return false;
    }

    public String toString() {
        return "Merged stereotype model with possible deployment types " + (Object)((Object)this.possibleDeploymentTypes) + ", required types " + this.requiredTypes + ", possible scopes " + this.possibleScopeTypes + " and supported scopes " + this.supportedScopes;
    }

    public String toDetailedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Merged stereotypes:\n");
        buffer.append("Bean name defaulted: " + this.beanNameDefaulted + "\n");
        buffer.append("Possible deployment types: " + this.getPossibleDeploymentTypes().toString());
        buffer.append(Strings.collectionToString("Possible scope types: ", this.getPossibleScopeTypes()));
        buffer.append(Strings.collectionToString("Required types: ", this.getRequiredTypes()));
        buffer.append(Strings.collectionToString("Supported scopes: ", this.getSupportedScopes()));
        return buffer.toString();
    }
}

