/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.webbeans.manager.Contextual;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.contexts.AbstractBeanMapAdaptor;
import org.jboss.webbeans.contexts.ApplicationContext;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.EnumerationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationBeanMap
extends AbstractBeanMapAdaptor {
    private LogProvider log = Logging.getLogProvider(ApplicationBeanMap.class);
    private ServletContext servletContext;

    public ApplicationBeanMap(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void clear() {
        for (String name : new EnumerationIterable(this.servletContext.getAttributeNames())) {
            if (!name.startsWith(this.getKeyPrefix())) continue;
            this.servletContext.removeAttribute(name);
        }
    }

    @Override
    public <T> T get(Contextual<? extends T> bean) {
        String key = this.getBeanKey(bean);
        Object instance = this.servletContext.getAttribute(key);
        this.log.trace("Searched application for key " + key + " and got " + instance);
        return (T)instance;
    }

    @Override
    public <T> void put(Contextual<? extends T> bean, T instance) {
        String key = this.getBeanKey(bean);
        this.servletContext.setAttribute(key, instance);
        this.log.trace("Stored instance " + instance + " for bean " + bean + " under key " + key + " in session");
    }

    @Override
    public <T> T remove(Contextual<? extends T> bean) {
        String key = this.getBeanKey(bean);
        Object result = this.servletContext.getAttribute(key);
        this.servletContext.removeAttribute(key);
        return (T)result;
    }

    @Override
    public Iterable<Contextual<? extends Object>> keySet() {
        ArrayList<Contextual<? extends Object>> beans = new ArrayList<Contextual<? extends Object>>();
        Enumeration names = this.servletContext.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(this.getKeyPrefix())) continue;
            String id = name.substring(this.getKeyPrefix().length() + 1);
            Contextual bean = (Contextual)CurrentManager.rootManager().getBeans().get(Integer.parseInt(id));
            beans.add((Contextual<? extends Object>)bean);
        }
        return beans;
    }

    @Override
    protected String getKeyPrefix() {
        return ApplicationContext.class.getName();
    }
}

