/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.webbeans.manager.Contextual;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.contexts.AbstractBeanMapAdaptor;
import org.jboss.webbeans.contexts.SessionContext;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBeanMap
extends AbstractBeanMapAdaptor {
    private static LogProvider log = Logging.getLogProvider(SessionBeanMap.class);
    private HttpSession session;

    public SessionBeanMap(HttpSession httpSession) {
        this.session = httpSession;
        log.trace("SessionBeanMap created with prefix " + this.getKeyPrefix());
    }

    @Override
    public <T> T get(Contextual<? extends T> bean) {
        String key = this.getBeanKey(bean);
        Object instance = this.session.getAttribute(key);
        log.trace("Searched session for key " + key + " and got " + instance);
        return (T)instance;
    }

    @Override
    public <T> T remove(Contextual<? extends T> bean) {
        T instance = this.get(bean);
        String key = this.getBeanKey(bean);
        this.session.removeAttribute(key);
        log.trace("Removed bean " + bean + " with key " + key + " from session");
        return instance;
    }

    @Override
    public void clear() {
        Enumeration names = this.session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.session.removeAttribute(name);
        }
        log.trace("Session cleared");
    }

    @Override
    public Iterable<Contextual<? extends Object>> keySet() {
        ArrayList<Contextual<? extends Object>> beans = new ArrayList<Contextual<? extends Object>>();
        Enumeration names = this.session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(this.getKeyPrefix())) continue;
            String id = name.substring(this.getKeyPrefix().length() + 1);
            Contextual bean = (Contextual)CurrentManager.rootManager().getBeans().get(Integer.parseInt(id));
            beans.add((Contextual<? extends Object>)bean);
        }
        return beans;
    }

    @Override
    public <T> void put(Contextual<? extends T> bean, T instance) {
        String key = this.getBeanKey(bean);
        this.session.setAttribute(key, instance);
        log.trace("Stored instance " + instance + " for bean " + bean + " under key " + key + " in session");
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        List beans = (List)this.keySet();
        buffer.append("Bean -> bean instance mappings in HTTP session: " + beans.size() + "\n");
        int i = 0;
        for (Contextual bean : beans) {
            Object instance = this.get(bean);
            buffer.append(++i + " - " + this.getBeanKey(bean) + ": " + instance + "\n");
        }
        return buffer.toString();
    }

    @Override
    protected String getKeyPrefix() {
        return SessionContext.class.getName();
    }
}

