/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import com.google.common.collect.ForwardingMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentCache<K, V>
extends ForwardingMap<K, Future<V>> {
    private ConcurrentMap<K, Future<V>> map = new ConcurrentHashMap<K, Future<V>>();

    public <T extends V> Future<T> getFuture(K key) {
        return (Future)super.get(key);
    }

    public <T extends V> T getValue(K key) {
        Future value = (Future)this.map.get(key);
        boolean interrupted = false;
        while (true) {
            try {
                Object v = value.get();
                return (T)v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                this.rethrow(e);
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public <E> E putIfAbsent(K key, Callable<E> callable) {
        FutureTask<E> value = (FutureTask<E>)this.map.get(key);
        if (value == null) {
            FutureTask<E> task;
            value = task = new FutureTask<E>(callable);
            this.map.put(key, task);
            task.run();
        }
        boolean interrupted = false;
        while (true) {
            try {
                Object v = value.get();
                return (E)v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                this.rethrow(e);
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected Map<K, Future<V>> delegate() {
        return this.map;
    }

    public String toString() {
        return Strings.mapToString("ProxyPool (bean -> proxy): ", this.map);
    }

    protected void rethrow(ExecutionException e) {
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        throw new IllegalStateException(e.getCause());
    }
}

