/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.jbossas.ejb3;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.common.registrar.spi.NotBoundException;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.kernel.Kernel;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.webbeans.bootstrap.spi.EjbDescriptor;
import org.jboss.webbeans.integration.jbossas.ejb3.JBossEJBDescriptorAdaptor;
import org.jboss.webbeans.integration.jbossas.ejb3.JBossMessageDrivenBeanDescriptorAdaptor;
import org.jboss.webbeans.integration.jbossas.ejb3.JBossSessionBeanDescriptorAdaptor;
import org.jboss.webbeans.integration.jbossas.vdf.KernelVDFConnector;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDiscoveryEnvironment {
    private List<EjbDescriptor<?>> ejbs;
    private static final LogProvider log = Logging.getLogProvider(EjbDiscoveryEnvironment.class);
    private Kernel kernel;
    private EjbReferenceResolver resolver;
    private static final String MC_BEAN_NAME_MAIN_DEPLOYER = "MainDeployer";

    public EjbDiscoveryEnvironment(ServletContext servletContext) {
        KernelVDFConnector kernelVDFConnector = new KernelVDFConnector(servletContext);
        this.kernel = (Kernel)kernelVDFConnector.getUtility();
        this.resolver = (EjbReferenceResolver)this.lookup("org.jboss.ejb3.EjbReferenceResolver");
        this.ejbs = new ArrayList();
        this.discoverEjbs();
    }

    public List<EjbDescriptor<?>> getEjbs() {
        return this.ejbs;
    }

    protected void discoverEjbs() {
        Object mainDeployer = Ejb3RegistrarLocator.locateRegistrar().lookup((Object)MC_BEAN_NAME_MAIN_DEPLOYER);
        assert (mainDeployer instanceof DeployerClient && mainDeployer instanceof MainDeployerStructure) : "Obtained Main Deployer is not of expected type";
        DeployerClient dc = (DeployerClient)mainDeployer;
        MainDeployerStructure mds = (MainDeployerStructure)mainDeployer;
        for (Deployment d : dc.getTopLevel()) {
            DeploymentUnit du = mds.getDeploymentUnit(d.getName());
            if (du.getAttachment(AttachmentNames.PROCESSED_METADATA, JBossMessageDrivenBeanMetaData.class) == null || !((JBossMetaData)du.getAttachment(JBossMetaData.class)).isEJB3x()) continue;
            log.info((Object)("EJB metadata for " + du.toString()));
            for (JBossEnterpriseBeanMetaData enterpriseBeanMetaData : ((JBossMetaData)du.getAttachment(JBossMetaData.class)).getEnterpriseBeans()) {
                JBossEJBDescriptorAdaptor ejbDescriptor;
                if (enterpriseBeanMetaData.isSession()) {
                    JBossSessionBeanMetaData sessionBeanMetaData = (JBossSessionBeanMetaData)enterpriseBeanMetaData;
                    ejbDescriptor = new JBossSessionBeanDescriptorAdaptor(sessionBeanMetaData, du, this.resolver);
                    log.info((Object)((Object)ejbDescriptor).toString());
                    this.ejbs.add(ejbDescriptor);
                    continue;
                }
                if (!enterpriseBeanMetaData.isMessageDriven()) continue;
                JBossMessageDrivenBeanMetaData messageDrivenBeanMetaData = (JBossMessageDrivenBeanMetaData)enterpriseBeanMetaData;
                ejbDescriptor = new JBossMessageDrivenBeanDescriptorAdaptor(messageDrivenBeanMetaData, du, this.resolver);
                log.info((Object)((Object)ejbDescriptor).toString());
                this.ejbs.add(ejbDescriptor);
            }
        }
    }

    public Object lookup(Object name) throws NotBoundException {
        ControllerContext context = this.kernel.getController().getContext(name, null);
        Throwable error = context.getError();
        if (error != null) {
            throw new RuntimeException("Could not lookup object at name \"" + name + "\" due to an error with the underlying " + ControllerContext.class.getSimpleName(), error);
        }
        Object target = context.getTarget();
        log.debug((Object)("Returning from name \"" + name + "\": " + target));
        return target;
    }
}

