/*
 * Decompiled with CFR 0.152.
 */
package org.sample.windup.ruleset;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationFilter;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.reporting.config.Hint;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeReferenceLocation;
import org.jboss.windup.rules.apps.xml.condition.XmlFile;
import org.jboss.windup.rules.apps.xml.model.XmlTypeReferenceModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class IncompatibleUseRuleProvider
extends WindupRuleProvider {
    private static final String TYPE_REF_SNIPPIT = "TYPE_REF_SNIPPIT";

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)XmlFile.matchesXpath((String)"/*[name() = 'ejb-jar']/*[name() = 'enterprise-beans']/*[name() = 'session']/*[name() = 'ejb-class']/text()").as("ejbs"), new Condition[]{JavaClass.references((String)"weblogic.ejb.*").at(new TypeReferenceLocation[]{TypeReferenceLocation.EXTENDS_TYPE}).as("refs")}).perform((Operation)Iteration.over((String)"refs").when((Condition)new AbstractIterationFilter<JavaTypeReferenceModel>(){

            public boolean evaluate(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel reference) {
                for (WindupVertexFrame frame : Variables.instance((GraphRewrite)event).findVariable("ejbs")) {
                    XmlTypeReferenceModel ejb = (XmlTypeReferenceModel)frame;
                    JavaSourceFileModel java = (JavaSourceFileModel)reference.getFile();
                    String qualifiedName = (java.getPackageName() + "." + java.getFileName()).replaceAll("\\.java$", "");
                    if (!qualifiedName.equals(ejb.getSourceSnippit())) continue;
                    context.put((Object)IncompatibleUseRuleProvider.TYPE_REF_SNIPPIT, (Object)reference.getSourceSnippit());
                    return true;
                }
                return false;
            }
        }).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                Hint.withText((String)("EJBs referencing " + context.get((Object)IncompatibleUseRuleProvider.TYPE_REF_SNIPPIT) + " are incompatible with JBoss EAP and should be replaced" + "with Java EE (non-proprietary) code.")).perform(event, context);
            }
        }).endIteration());
    }
}

