package com.plugtree.test.p5;

import com.plugtree.test.p5.model.SimpleObservationType;
import com.plugtree.test.p5.model.SimpleDiscreteObservation;
import com.plugtree.test.p5.model.SimplePatient;
import com.plugtree.test.p5.model.SimpleRuleTime;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgePackage;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import java.io.*;
import java.util.*;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;


public class SimpleHighRiskForSepsisTest
{
    
    @Test
    public void fullTest(){
        this.doTest("/rules/SimpleHighRiskSepsis.drl");
    }
    
    @Test
    public void timeAsSinglePatternTest(){
        this.doTest("/rules/SimpleHighRiskSepsis_SingleSimpleRuleTime.drl");
    }
    
    @Test
    public void timeAsSinglePatternNoBindingsTest(){
        this.doTest("/rules/SimpleHighRiskSepsis_SingleSimpleRuleTime_op2.drl");
    }
    
    @Test
    public void timeAsSinglePattern1PatternMovedToNewRuleTest(){
        this.doTest("/rules/SimpleHighRiskSepsis_SingleSimpleRuleTime_op1.drl");
    }
    
    @Test
    public void timeAsSinglePatternAndIndividualRulesTest(){
        this.doTest("/rules/SimpleHighRiskSepsis_ors.drl");
    }
    
    @Test
    public void timeAsSinglePatternAndIndividualRulesWithoutParenthesisTest(){
        this.doTest("/rules/SimpleHighRiskSepsis_ors_noparanthesis.drl");
    }
    
    
    
    
    
    
    public final int doTest(String resourceName){
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource resource = ResourceFactory.newReaderResource(new StringReader(getRuleFromResource(resourceName)));
        kbuilder.add(resource, ResourceType.DRL);
        if (kbuilder.hasErrors()){
            Iterator<KnowledgeBuilderError> errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                KnowledgeBuilderError knowledgeBuilderError = errors.next();
                System.out.println(knowledgeBuilderError.getMessage());
            }
            throw new IllegalStateException("Compiling errors!");
        }

        Collection<KnowledgePackage> pkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals(1, pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession knowledgeSession = kbase.newStatefulKnowledgeSession();
        knowledgeSession.getKnowledgeBase().addKnowledgePackages(pkgs);
        KnowledgeRuntimeLoggerFactory.newConsoleLogger(knowledgeSession);
        List<Object> facts = new ArrayList<Object>();

        //patient
        SimplePatient patient = CreatePatient();
        facts.add(patient);
        //observation types
        SimpleObservationType otPulse = CreateObservationType(8966);
        facts.add(otPulse);
        SimpleObservationType otWBC = CreateObservationType(8971);
        facts.add(otWBC);
        SimpleObservationType otLACT = CreateObservationType( 8973);
        facts.add(otLACT);
        SimpleObservationType otBP = CreateObservationType(8984);
        facts.add(otBP);

        //Discrete Observations
        SimpleDiscreteObservation obsPulse = CreateDiscreteObservation(patient, otPulse, "99");
        facts.add(obsPulse);
        SimpleDiscreteObservation obsWbc = CreateDiscreteObservation(patient, otWBC, "15");
        facts.add(obsWbc);
        SimpleDiscreteObservation obsLact = CreateDiscreteObservation(patient, otLACT, "3.6");
        facts.add(obsLact);
        SimpleDiscreteObservation obsBp = CreateDiscreteObservation(patient, otBP, "45");
        facts.add(obsBp);

        SimpleRuleTime nowFact = new SimpleRuleTime(new Date());
        facts.add(nowFact);

        for (Object fact : facts)
        {
            knowledgeSession.insert(fact);
        }

        int rulesFired = knowledgeSession.fireAllRules();
        //Assert.assertEquals(5, rulesFired);
        
        return rulesFired;
    }
    
    protected String getRuleFromResource(String resource)
    {
        String drlString;
        try
        {
            drlString = getFileAsString(resource);
        }
        catch(IOException ex)
        {
            throw new RuntimeException(ex);
        }
        return drlString;
    }

    public String getFileAsString(String resource) throws IOException
    {
        InputStream inputStream = FileReader.class.getResourceAsStream(resource);
        if(inputStream == null) {
            throw new FileNotFoundException(resource);
        }

        byte[] buffer = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            buffer = new byte[inputStream.available()];
            bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.read(buffer);
        } catch (IOException e) {
            throw e;
        } finally {
            inputStream.close();
            if(bufferedInputStream != null){
                bufferedInputStream.close();
            }
        }

        return new String(buffer);
    }


    private SimpleObservationType CreateObservationType(Integer dbKey)
    {
        SimpleObservationType fact = new SimpleObservationType();
        fact.setSpaceId(UUID.randomUUID().toString());
        fact.setObservationTypeDbKey(dbKey);
        return fact;
    }

    public static Date addHours(Date date, int numberOfHours){
        if(date == null)
            throw new RuntimeException("date is null");
        return new DateTime(date).plus(Duration.standardHours(numberOfHours)).toDate();
    }


    private SimpleDiscreteObservation CreateDiscreteObservation(SimplePatient patient, SimpleObservationType type, String value)
    {
        SimpleDiscreteObservation fact = new SimpleDiscreteObservation();
        fact.setSpaceId(UUID.randomUUID().toString());
        fact.setPatientSpaceId(patient.getSpaceId());
        fact.setObservationTypeSpaceId(type.getSpaceId());
        fact.setObservationValue(value);
        fact.setObservationDate(addHours(new Date(), -1));
        fact.setTrend(1.1);
        return fact;
    }

    private SimplePatient CreatePatient()
    {
        SimplePatient fact = new SimplePatient();
        fact.setSpaceId(UUID.randomUUID().toString());
        return fact;
    }

}
