package grails.drools6

import org.kie.api.io.ResourceType
import org.kie.internal.builder.KnowledgeBuilderConfiguration
import org.kie.internal.builder.KnowledgeBuilderError
import org.kie.internal.builder.KnowledgeBuilderErrors
import org.kie.internal.builder.KnowledgeBuilderFactory
import org.kie.internal.builder.conf.PropertySpecificOption
import org.kie.internal.io.ResourceFactory

class DroolsService {

    def loadEngine() {
        KnowledgeBuilderConfiguration builderConfig = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        builderConfig.setOption(PropertySpecificOption.ALWAYS);
        def kbBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder(builderConfig)

        log.info("loading mandatory rules from xtrules.drl")
        kbBuilder.add(ResourceFactory.newClassPathResource("com/xtmotion/docbuilder/xtrules.drl"), ResourceType.DRL)

        KnowledgeBuilderErrors errors = kbBuilder.getErrors();
        if (errors.size() > 0) {
            def s = [];
            for (KnowledgeBuilderError error : errors) {
                // log.error(error.toString());
                System.out.println(error.toString())
                s.add("### " + error.toString());

            }
            // undo
            kbBuilder.undo()

            // TODO wrap into some other kind of exception which will render better on client
            throw new Exception("Could not parse knowledge:" + s.join("\n"));
        }

        return kbBuilder
    }
}
