package my.tests.drools.osgi.camel;

import my.tests.drools.osgi.expert.Expert;
import my.tests.drools.osgi.expert.Problem;
import my.tests.drools.osgi.expert.Solution;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.log4j.Logger;

public class ExpertProcessor implements Processor {

	private final static Logger LOGGER = Logger.getLogger(ExpertProcessor.class);

	private Expert expert;

	public Expert getExpert() {
		return expert;
	}

	public void setExpert(final Expert expert) {
		this.expert = expert;
	}

	@Override
	public void process(final Exchange exchange) throws Exception {

		LOGGER.info("Processing exchange for expert analyse...");

		Object what = exchange.getIn().getBody();
		Problem problem = new Problem(what);

		LOGGER.info("Problem is : " + problem);

		Solution solution = getExpert().analyse(problem);

		LOGGER.info("Solution is : " + solution);

		exchange.getIn().setBody(solution);

		LOGGER.info("Expert analyse done !");

	}

}
