package my.tests.drools.osgi.expert.kie;

import java.util.LinkedHashMap;
import java.util.Map;

import my.tests.drools.osgi.expert.Expert;
import my.tests.drools.osgi.expert.Problem;
import my.tests.drools.osgi.expert.Solution;

import org.apache.log4j.Logger;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class KieExpert implements Expert {

	private final static Logger LOGGER = Logger.getLogger(KieExpert.class);

	private final KieContainer kieContainer;

	public KieExpert() {
		LOGGER.info("Building new Expert...");
		KieServices kieServices = KieServices.Factory.get();
		kieContainer = kieServices.getKieClasspathContainer(getClass().getClassLoader());
		LOGGER.info("KIE Expert ready.");
	}

	public Solution analyse(Problem problem) {
		LOGGER.info("Expert will analyse problem : " + problem);
		Map<String, Object> dialog = new LinkedHashMap<>();
		KieSession kieSession = kieContainer.newKieSession("MyKSession");
		LOGGER.info("Rules are ok : " + kieSession);
		kieSession.setGlobal("dialog", dialog);
		kieSession.insert(problem);
		kieSession.fireAllRules();
		kieSession.dispose();
		LOGGER.info("Expert analysed problem : " + dialog);
		return (Solution) dialog.get("solution");
	}

}