package com.acme.drools6test.anotherleak;

import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.drools.core.time.SessionPseudoClock;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.acme.objectmodel.ReadingHeader;
import com.acme.objectmodel.SensorReading;

/**
 * Execute with heap dump on out of memory error
 * -XX:+HeapDumpOnOutOfMemoryError -Xms128m -Xmx128m -ea
 */
public class AppAdvanceInsertFire {
	final static Logger LOG = LoggerFactory.getLogger(AppAdvanceInsertFire.class);
	
	private static DatatypeFactory df;
	
	static {
		try {
			df = DatatypeFactory.newInstance();
		} catch (DatatypeConfigurationException e) {
			e.printStackTrace();
		}
	}
	
    public static void main( String[] args ) throws InterruptedException {
    	KieServices kieServices = KieServices.Factory.get();
        KieContainer kContainer = kieServices.getKieClasspathContainer();
        KieBaseConfiguration kieBaseConf = kieServices.newKieBaseConfiguration();
		kieBaseConf.setOption( EventProcessingOption.STREAM );
        KieBase kieBase = kContainer.newKieBase(kieBaseConf);
       
        LOG.info("There should be rules: ");
        for ( KiePackage kp : kieBase.getKiePackages() ) {
        	for (Rule rule : kp.getRules()) {
        		System.out.println("kp" + kp + " rule " + rule.getName());
        	}
        }
        
        LOG.info("Creating kieSession");
        KieSessionConfiguration config = kieServices.newKieSessionConfiguration();
		config.setOption( ClockTypeOption.get("pseudo") );
        KieSession session = kieBase.newKieSession(config, null);
                
        LOG.info("I start to input data now.");
        for (int i = 0; true ; i++) {
        	String id = (i%2==0)?"A":"B";
        	ReadingHeader header = new ReadingHeader(id);
        	String value = "nevermind";
        	SensorReading reading = new SensorReading(header, value);
        	
        	advanceInsertFire(reading, session);

        }
    }

	private static void advanceInsertFire(SensorReading reading, KieSession session) {
		SessionPseudoClock clock = session.getSessionClock();
		clock.advanceTime(100, TimeUnit.MILLISECONDS);
		session.insert(reading);
		session.fireAllRules();
		
	}
    
    
}
