package com.acme.objectmodel;

import org.apache.commons.lang3.time.FastDateFormat;

public class Alert {
	
	private static FastDateFormat fdf;
	static {
		fdf = FastDateFormat.getInstance("yyyy-MM-dd 'T' HH:mm:ss.SSS Z");
	}

	private long ts;
	private SensorReading sr;
	private String condition;
	private AlertType type;
	
	public Alert(long ts, String condition,	AlertType type, SensorReading ddt) {
		super();
		this.ts = ts;
		this.sr = ddt;
		this.condition = condition;
		this.type = type;
	}

	public long getTs() {
		return ts;
	}
	
	public String getTsFormatted() {
		return fdf.format(ts);
	}

	public SensorReading getSr() {
		return sr;
	}

	public String getCondition() {
		return condition;
	}

	public AlertType getType() {
		return type;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Alert [");
		if (getTsFormatted() != null)
			builder.append("getTsFormatted()=").append(getTsFormatted());
		if (condition != null)
			builder.append("condition=").append(condition).append(", ");
		if (type != null)
			builder.append("type=").append(type).append(", ");
		if (sr != null)
			builder.append("sr=").append(sr).append(", ");
		builder.append(", ts=").append(ts).append(", ");
		builder.append("]");
		return builder.toString();
	}
}
