package demo;


import org.apache.commons.lang.RandomStringUtils;

public class Event {
    private final long eventId;
    private final long timestamp;
    private final String description;

    public Event(long eventId) {
        this.eventId = eventId;
        timestamp = System.currentTimeMillis();
        this.description = RandomStringUtils.randomAscii(1024);
    }

    public long getEventId() {
        return eventId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return "Heartbeat: " + eventId;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
            + ((description == null) ? 0 : description.hashCode());
        result = prime * result + (int) (eventId ^ (eventId >>> 32));
        result = prime * result + (int) (timestamp ^ (timestamp >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event) obj;
        if (description == null) {
            if (other.description != null) {
                return false;
            }
        } else if (!description.equals(other.description)) {
            return false;
        }
        if (eventId != other.eventId) {
            return false;
        }
        if (timestamp != other.timestamp) {
            return false;
        }
        return true;
    }

}
