package demo;

import java.io.File;
import java.util.Date;
import java.util.Scanner;

import org.drools.core.common.DefaultAgenda;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.io.ResourceFactory;

public class TestDriver {

	private KieSession ksession;
	public boolean shutdown;

	private String getRule() throws Exception {
		return new Scanner(new File("src/main/resources/heartbeat.drl"))
				.useDelimiter("\\Z").next();
	}

	public TestDriver() {

		String drl = "";
		try {
			drl = getRule();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		KnowledgeBuilder kbuilder = KnowledgeBuilderFactory
				.newKnowledgeBuilder();
		kbuilder.add(ResourceFactory.newByteArrayResource(drl.getBytes()),
				ResourceType.DRL);
		if (kbuilder.hasErrors()) {
			System.err.println(kbuilder.getResults(ResultSeverity.ERROR)
					.toString());
			throw new RuntimeException("Rule Errors");
		}

		KieBaseConfiguration baseConfig = KnowledgeBaseFactory
				.newKnowledgeBaseConfiguration();
		baseConfig.setOption(EventProcessingOption.STREAM);
		KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase(baseConfig);
		kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());

		ksession = kbase.newKieSession();
	}

	public KieSession getSession() {
		return ksession;
	}

	public static void main(String[] argv) {
		TestDriver testDriver = new TestDriver();

		int eventId = 1;

		KieSession ksession = testDriver.getSession();

		for (eventId = 1; eventId <= 600000; eventId++) {
			ksession.insert(new Event(eventId));
			ksession.fireAllRules();
		}

		System.out.println();

		System.out.println("Done sending events: " + new Date());
		System.out
				.println("Press any key to send the next event (Ctrl-C should quit)...");

		int timer = 0;
		while (true) {
			try {
				if (System.in.available() > 0) {
					System.in.read();
					ksession.insert(new Event(eventId++));
					timer = 0;
				}
				Thread.sleep(1000);
				timer++;
				System.out.println(timer + "s");
				ksession.fireAllRules();
			} catch (Exception e) {
			}
		}
	}
}
